/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.problem;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.pa.fedc.FEDCJavaExecutable;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.io.File;
import java.io.IOException;

public class GetDumpData
implements Runnable,
FEDCJavaExecutable {
    private static final String TRACE_MASKT = "XPAGETDT";
    private static final String TRACE_MASKF = "XPAGETDF";
    private static final String TRACE_MASKD = "XPAGETDD";
    private static final int _maxNumberOfProblems = 5;
    private String _parms = null;
    private Problem _problem;

    public GetDumpData(String parms) {
        Trace.trace(TRACE_MASKT, "--> GetDumpData.ctor (" + parms + ")");
        this._parms = parms;
        Trace.trace(TRACE_MASKT, "<-- GetDumpData.ctor (" + parms + ")");
    }

    public Problem getProblem() {
        Trace.trace(TRACE_MASKT, "<--> getProblem ");
        return this._problem;
    }

    public void setProblem(Problem problem) {
        Trace.trace(TRACE_MASKT, "--> setProblem ");
        this._problem = problem;
        Trace.trace(TRACE_MASKD, "the problem is " + problem.getUniqueKey());
        Trace.trace(TRACE_MASKT, "<-- setProblem ");
    }

    public void run() {
        Object pm = null;
        Trace.trace(TRACE_MASKD, "--> GetDumpData.run()");
        File[] jvmDumpFiles = null;
        try {
            File jvmDumpDirectory;
            String jvmDumpPath = BaseFileControl.getFilePath("jvmdumptargetdirectory");
            if (jvmDumpPath != null && (jvmDumpDirectory = new File(jvmDumpPath)) != null) {
                jvmDumpFiles = jvmDumpDirectory.listFiles();
            }
            Trace.trace(TRACE_MASKD, "got " + jvmDumpFiles.length + " files to process");
            if (jvmDumpFiles != null && jvmDumpFiles.length > 0) {
                for (int i = 0; i < jvmDumpFiles.length; ++i) {
                    String dumpFileName = jvmDumpFiles[i].getAbsolutePath();
                    Trace.trace(TRACE_MASKD, "processing " + dumpFileName);
                    Trace.trace(TRACE_MASKD, "lowercase name is" + dumpFileName.toLowerCase());
                    String[] cmdString = null;
                    if (this._parms.equals("--clean")) {
                        Trace.trace(TRACE_MASKD, "deleting " + dumpFileName);
                        cmdString = new String[]{"rm", "-rf", dumpFileName};
                        this.runIt(cmdString);
                        continue;
                    }
                    if (dumpFileName.toLowerCase().endsWith("bz2")) continue;
                    Trace.trace(TRACE_MASKD, "compressing " + dumpFileName);
                    cmdString = new String[]{"bzip2", "-zvf", dumpFileName};
                    this.runIt(cmdString);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    private void runIt(String[] cmdString) throws IOException {
        Trace.trace(TRACE_MASKF, "Issuing cmd: ");
        for (int j = 0; j < cmdString.length; ++j) {
            Trace.trace(TRACE_MASKF, "  " + cmdString[j]);
        }
        Process process = Runtime.getRuntime().exec(cmdString);
        boolean dumpRunning = true;
        while (dumpRunning) {
            Trace.trace(TRACE_MASKD, "step 1");
            try {
                Trace.trace(TRACE_MASKD, "running the command");
                process.waitFor();
                dumpRunning = false;
                int exitValue = process.exitValue();
                Trace.trace(TRACE_MASKF, "Exit status " + exitValue + " from dumper process ");
                if (exitValue == 0) continue;
                Trace.trace(TRACE_MASKF, "Exit status " + exitValue + " from dumper process");
            }
            catch (InterruptedException e) {}
        }
    }

    public static void main(String[] args) {
        System.out.println("running");
        try {
            GetDumpData me = new GetDumpData("test");
            CommonProblem newProblem = new CommonProblem("Test problem");
            me.setProblem(newProblem);
            me.run();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
            System.out.println("got an exception");
            e.printStackTrace();
        }
        System.out.println("done");
    }
}

